*Merge EU-SILC files to one file with a record per person

*Tim Goedemé, 20/05/2019

*Globals
********

global place1 ...\EU-SILC\Cross\2020-04\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK





*1. Country datasets with all variables
***************************************

foreach ctry of global countries {
	forvalues year = 2004(1)2018 {
		clear
		cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D_sd.dta"
		if _rc==0 {
			
			di "`year'; `ctry'"
			use "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D_sd.dta"
			merge 1:1 year country hid using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'H.dta"
			cap drop _merge
			merge 1:m year country hid using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'R.dta"
			cap drop _merge
			merge 1:1 year country pid using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'P.dta"
			cap drop _merge
			compress
			
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", replace
		}
	}
}

